FILESEXTRAPATHS_prepend := "${THISDIR}/files:"

SRC_URI += " \
           file://AmazonRootCA1.crt \
           file://AmazonRootCA2.crt \
           file://AmazonRootCA3.crt \
           file://AmazonRootCA4.crt \
           file://SFSRootCAG2.crt \
           "


do_install_append_class-target() {

        install -m 0644 ${WORKDIR}/AmazonRootCA1.crt ${D}${datadir}/ca-certificates
        install -m 0644 ${WORKDIR}/AmazonRootCA2.crt ${D}${datadir}/ca-certificates
        install -m 0644 ${WORKDIR}/AmazonRootCA3.crt ${D}${datadir}/ca-certificates
        install -m 0644 ${WORKDIR}/AmazonRootCA4.crt ${D}${datadir}/ca-certificates
        install -m 0644 ${WORKDIR}/SFSRootCAG2.crt ${D}${datadir}/ca-certificates

        install -d ${D}${sysconfdir}
        {
            echo "# Lines starting with # will be ignored"
            echo "# Lines starting with ! will remove certificate on next update"
            echo "#"
            find ${D}${datadir}/ca-certificates -type f -name '*.crt' |\
                sed 's,^${D}${datadir}/ca-certificates/,,'
        } >${D}${sysconfdir}/ca-certificates.conf

# Restructure Root CA Trust Store RDKALL-2429
# Replacing the Root CA Trust store from CPC repo
        bbnote "Removing rdk-v certs installed from debian ca store"
        rm -rf ${D}${datadir}/ca-certificates/*
        rm -f ${D}${sysconfdir}/ca-certificates.conf
}

FILES_${PN} += "${datadir}/ca-certificates/*.crt"
